/*
	v0.1 - [20.09.2011] First release 
	v0.1a - [23.09.2011] Code optimizations, added macros options 

	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/

#include <amxmodx>
#include <fakemeta_util>
#include <hamsandwich>
#include <xs>

#define PLUGIN 	"hl_adrenaline_upd"
#define VERSION "0.1a"
#define AUTHOR 	"Turanga_Leela"

#define RENDER(%1)	1 << %1 & ~(1 << HASTE)

/*** - OPTIONS - ***/

//#define DEBUG			// Only for test plugin

//#define Half_Life		// Remove comment for Half-Life or may be CSDM :D

#define ADRENALINE_SUB	5	// Adrenaline lose

/* QUAD_DMG */
#define QUAD_MULTIPLE	2
#define QUAD_BONUS_DMG	1	// Bonus dmg vs DEFENCE rune (Not 1 dmg :D, this is multiple)

/* HASTE */
#define GRAVITY		0.5	// 0.5 - Half normal gravity
#define LOSE_HP		10.0	// Max Hp lose (fall to the ground)

/* DEFENCE */
#define DEFENCE_BLOCK	0.1	// 0.1 = 10% Damage received

/* REGENERATION */
#define MAX_POINTS 	100.0	// Max Hp/Ap (Limit regen)
#define HEALTH_REGEN	2.0
#define ARMOR_REGEN	1.0

/*** - END - ***/
		
new const quake_III_sounds[][] =
{
	"q3/quaddamage.mp3",
	"q3/haste.mp3",
	"q3/invisibility.mp3",
	"q3/regeneration.mp3",
	"q3/protect.mp3",
	"q3/wearoff.mp3"
}

enum _:Q3_RUNES
{
	QUAD_DMG = 1,
	REGENERATION,
	HASTE,
	INVISIBILITY,
	DEFENCE
}

enum _:MASSIVE_SIZE
{
	RUNE,
	ID_ADRENALINE	
}

new
adrenaline[33][2],
adrenaline_cvar,
g_MaxPlayers

public plugin_precache()
{
	for(new i; i < sizeof quake_III_sounds; i++)
		precache_sound(quake_III_sounds[i])
}

public client_disconnect(id)
{
	adrenaline[id][RUNE] = 0
	adrenaline[id][ID_ADRENALINE] = 0
}

#if defined DEBUG	
public give_rune(id)
{
	block_rune(id)
		
	adrenaline[id][ID_ADRENALINE] = 1000
	new string[8]

	read_argv(id, string, charsmax(string))	
	new num = str_to_num(string)
	
	add_rune(id, num)	
}
#endif

public plugin_init()
{	
#if defined DEBUG	
	adrenaline_cvar = register_cvar("amx_valve_adrenaline", "250")
	register_clcmd("rune", "give_rune")
#endif
#if !defined DEBUG	
	adrenaline_cvar = register_cvar("amx_valve_adrenaline", "10")
#endif	
	g_MaxPlayers = get_maxplayers()
	
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("DeathMsg", "after_kill", "a")
	register_forward(FM_PlayerPreThink, "FwdPlayerPreThink")
	RegisterHam(Ham_TakeDamage, "player", "take_dmg_Pre")

#if !defined Half_Life
	register_logevent("new_round_start", 2, "1=Round_Start")
#endif
}

#if !defined Half_Life
public new_round_start()
{
	for(new id = 1; id <= g_MaxPlayers; id++)
	{
		if(is_user_connected(id))
			block_rune(id)
	}
}
#endif

public FwdPlayerPreThink(id) 
{ 
	if(adrenaline[id][RUNE] == HASTE) 
	{
		static Float:velocity[3]
		
		if(pev(id, pev_button) & (IN_FORWARD | IN_BACK | IN_LEFT | IN_RIGHT))
		{
			pev(id, pev_velocity, velocity)
			xs_vec_mul_scalar(velocity, 1.01, velocity)
			set_pev(id, pev_velocity, velocity)
		}	
	}
}

public take_dmg_Pre(id, idinflictor, idattacker, Float:damage, damagebits)
{
	if(idattacker > g_MaxPlayers)
		return
	
	static dmg
	dmg = 0
	
	if(adrenaline[id][RUNE] == DEFENCE && adrenaline[idattacker][RUNE] == QUAD_DMG)
		damage *= (QUAD_MULTIPLE + QUAD_BONUS_DMG) * DEFENCE_BLOCK, dmg = 1
	
	else if(adrenaline[id][RUNE] == DEFENCE)
		damage *= DEFENCE_BLOCK, dmg = 1

	else if(adrenaline[idattacker][RUNE] == QUAD_DMG)
		damage *= QUAD_MULTIPLE, dmg = 1
		
	else if(adrenaline[id][RUNE] == HASTE && !idattacker && damage > LOSE_HP)
		damage = LOSE_HP, dmg = 1
	if(dmg)
		SetHamParamFloat(4, damage)
}

gravity_func(id, mode)
{
	set_pev(id, pev_gravity, mode ? 1.0 : GRAVITY)
}

block_rune(id)
{
	if(adrenaline[id][RUNE])
	{
		if(RENDER(adrenaline[id][RUNE]))
			rendering_func(id, kRenderFxNone, 0, 0, 0, kRenderNormal)
	
		else gravity_func(id, 1)
	
		adrenaline[id][RUNE] = 0
	}
}

public after_kill()
{
	new killer = read_data(1)
	new victim = read_data(2)

	adrenaline[victim][ID_ADRENALINE] /= 2
	block_rune(victim)
		
	if(!is_user_alive(killer)) return
	
	new bonus, weapon = get_user_weapon(killer)

#if !defined Half_Life
	switch(weapon)
	{
		case CSW_KNIFE:												bonus = 40
		case CSW_M3, CSW_HEGRENADE, CSW_XM1014, CSW_MAC10, CSW_TMP, CSW_UMP45, CSW_M249, CSW_MP5NAVY, CSW_P90:	bonus = 10
		case CSW_FIVESEVEN, CSW_DEAGLE, CSW_ELITE, CSW_GLOCK18, CSW_USP, CSW_P228: 				bonus = 5
		case CSW_AWP, CSW_SCOUT, CSW_SG550, CSW_G3SG1:								bonus = -5
	}	
#endif		
#if defined Half_Life	
	switch(weapon)
	{
		case HLW_CROWBAR:				bonus = 40
		case HLW_GLOCK, HLW_SNARK:			bonus = 10
		case HLW_HANDGRENADE, HLW_SATCHEL, HLW_TRIPMINE:	bonus = 5
		case HLW_GAUSS, HLW_CROSSBOW:			bonus = -5
	}	
#endif
	adrenaline[killer][ID_ADRENALINE] += get_pcvar_num(adrenaline_cvar) + bonus
	
	if(adrenaline[killer][ID_ADRENALINE] >= 100)
	{
		new chance = adrenaline[killer][RUNE] ? 0 : random_num(1, 5)
		
		if(chance)
			add_rune(killer, chance)
	}	
}

add_rune(id, q3_rune)
{	
	new kRenderFx, red, green, blue, kRender, mp3_sound[32], rune_q3[16]
	
	switch(q3_rune)
	{
		case QUAD_DMG:	
		{		
			rune_q3 = "Quad Damage"
			kRenderFx = kRenderFxGlowShell
			kRender = kRenderGlow
			blue = 255
			mp3_sound = "mp3 play sound/q3/quaddamage"
			adrenaline[id][RUNE] = QUAD_DMG	
		}	
		case REGENERATION:
		{			
			rune_q3 = "Regeneration"
			kRenderFx = kRenderFxGlowShell
			kRender = kRenderGlow
			red = 255
			adrenaline[id][RUNE] = REGENERATION
			mp3_sound = "mp3 play sound/q3/regeneration"
			
			regeneration_func(id)
		}
		case HASTE:
		{		
			rune_q3 = "Haste"		
			red = 255
			green = 100
			blue = 255	
			adrenaline[id][RUNE] = HASTE
			mp3_sound = "mp3 play sound/q3/haste"
			
			gravity_func(id, 0)
		}
		case INVISIBILITY:
		{					
			rune_q3 = "Invisibility"	
			blue = 150
			green = 255
			kRenderFx = kRenderFxNone
			kRender = kRenderTransAlpha
			adrenaline[id][RUNE] = INVISIBILITY
			mp3_sound = "mp3 play sound/q3/invisibility"
		}	
		case DEFENCE:
		{
			rune_q3 = "Defence"		
			red = 255
			green = 200
			kRenderFx = kRenderFxGlowShell
			kRender = kRenderGlow
			adrenaline[id][RUNE] = DEFENCE	
			mp3_sound = "mp3 play sound/q3/protect"
		}
	}
	
	if(check_bot(id))
	{
		set_hudmessage(red, green, blue, -1.0, 0.60, 2, 1.0, 5.0, 0.75, 2.5, -1)
		show_hudmessage(id, "%s", rune_q3)	
	}
	
	mp3_play_func(id, mp3_sound)
	
	if(RENDER(adrenaline[id][RUNE]))
		rendering_func(id, kRenderFx, red, green, blue, kRender)
	
	remove_adrenaline(id)		
}

rendering_func(id, kRenderFx, r, g, b, kRender)
	fm_set_rendering(id, kRenderFx, r, g, b, kRender, 32)
	
check_bot(id)
{
	if(is_user_bot(id))
		return false
	
	return true	
}

public remove_adrenaline(id)
{
	if(!adrenaline[id][RUNE]) return
	
	adrenaline[id][ID_ADRENALINE] -= ADRENALINE_SUB
#if defined DEBUG	
	client_print(id, print_chat, "Time remain: %d", adrenaline[id][ID_ADRENALINE] / ADRENALINE_SUB)
#endif	
	if(0 < adrenaline[id][ID_ADRENALINE] <= ADRENALINE_SUB * 5)
		mp3_play_func(id, "mp3 play sound/q3/wearoff")
	
	else if(0 >= adrenaline[id][ID_ADRENALINE])
	{
		adrenaline[id][ID_ADRENALINE] = 0

		block_rune(id)
		return
	}
	
	set_task(1.0, "remove_adrenaline", id)
}

mp3_play_func(id, string[])
{
	if(check_bot(id))
		client_cmd(id, string)
}

set_points(id, mode, Float:bonus)
{
	static Float:value, pev_is
	pev_is = mode ? pev_armorvalue : pev_health
	
	pev(id, pev_is, value)
	value += bonus
	
	if(value > MAX_POINTS)
		value = MAX_POINTS
	
	set_pev(id, pev_is, value)	
}

public regeneration_func(id)
{
	if(!adrenaline[id][RUNE]) return
	
	set_points(id, 0, HEALTH_REGEN)
	set_points(id, 1, ARMOR_REGEN)
	
	set_task(1.0, "regeneration_func", id)
}