/*
Copyright 2011 m0skVi4a ;]

Plugin created in Bulgaria


Plugin thread 1
http://www.amxmodxbg.org/forum/viewtopic.php?t=35879

Plugin thread 2
http://forums.alliedmods.net/showthread.php?t=168274

Original posted by m0skVi4a ;]



Description:

This plugin change the Counter - Strike 1.6 classic style to Surf. The plugin have help, respawn, spawn protection, semiclip system and timer.
 

Commands:

say /surfhelp
say_team /surfhelp
to show the Surf Mod help MOTD

say /respawn
say_team /respawn
to respawn you

say /surftimer
say_team /surftimer
to open surf timer menu


CVARS:

"surf_on"		 - 	Is the plugin on(1) or off(0).   Default: 1
"surf_help"		 - 	Is the surf help on(1) or off(0).   Default: 1
"surf_help_mes"  	 - 	In how many seconds to display the surf help message.   Default: 120.0
"surf_respawn" 		 - 	Is the respawning on(1) or off(0).   Default: 1
"surf_respawn_command"	 -	Is the say /respawn command on(1) or off(0).   Default: 1
"surf_respawn_time"  	 - 	Time in seconds after dead to respawn.   Default: 1.0
"surf_sp"	 	 - 	Is the spawn protection on(1) or off(0)   Default: 1
"surf_sp_time"	 	 - 	How many seconds is the protection.   Default: 5.0
"surf_semi"	 	 - 	Is the semiclip on(1) or off(0).   Default: 1
"surf_timer"	 	 - 	Is the surf timer on(1) or off(0).   Default: 1
"surf_timer_max" 	 - 	How much is the max seconds that surf timer can count.   Default: 86400(24 hours)
"surf_timer_hud" 	 -      Time in seconds after Stop timer to stop timers hud.   Default: 10.0

All CVARS are without quotes


Credits:

m0skVi4a ;]    	-	for the idea and making the plugin
ConnorMcLeod 	- 	for his Semiclip plugin
SpeeD	    	-	for his Spawn Protection plugin and testing the plugin
L@m3r40 =]  	- 	for ideas and testing the plugin
SGT		-	for ideas for the plugin


Changelog:

August 11, 2011   -  v1.0  -  First Release
August 21, 2011   -  v1.1  -  Changed semiclip method, added Universal Timer, added code styling, small optimization.
September 26, 2011  -  v1.2  -  Fixed some bugs
October 1, 2011   -  v1.3  -  Litle optimization, added multilingual file, SurfMod Help MOTD is in CSTRIKE dir, Fixed bug that don't spawns you when connect, added "surf_respawn_command" cvar.
October 2, 2011   -  v1.3 FIX 1 - Fixed bug respawn on connect when plugin is off, there are merge some features in the semiclip
October 2, 2011   -  v1.3 FIX 2 - Fixed bug that don't spawns you when connect
November 8, 2011   -  v1.3 FIX 3 - Fixed bug that don't spawns you when connect



Visit www.amxmodxbg.org 
Visit www.forums.alliedmods.net 
*/


#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>

#define MarkUserAlive(%1) g_bAlive |= 1<<(%1 & 31)
#define ClearUserAlive(%1) g_bAlive &= ~(1<<(%1 & 31))
#define IsAlive(%1) g_bAlive & 1<<(%1 & 31)

#define TASK_TIMER 2133
#define TASK_HUD 3312

new g_on, g_help, g_helpint, g_res, g_res_com, g_restime, g_spenabled, g_sptime, g_semi, g_timer, g_max, g_hud;
new SPTimer[33];
new SurfTimer[33];
new g_bAlive;
new SyncHud1, SayTxT;
new const prefix[]="[SURF MOD]";
const MAX_PLAYERS = 32;
new g_iTeam[MAX_PLAYERS+1];
new const g_szTeams[][] =
{
    "",
    "TERRORIST",
    "CT"
}

enum {
    _T = 1,
    _CT
}
new g_iTeamSemiclip = _T | _CT

public plugin_init()
{
	register_plugin("Surf Mod", "1.3 FIX 3", "m0skVi4a ;]")
	
	g_on = register_cvar("surf_on", "1")
	g_help = register_cvar("surf_help", "1")
	g_helpint = register_cvar("surf_help_mes", "120.0")
	g_res = register_cvar("surf_respawn", "1")
	g_res_com = register_cvar("surf_respawn_command", "1")
	g_restime = register_cvar("surf_respawn_time", "1.0")
	g_spenabled = register_cvar("surf_sp","1")
	g_sptime = register_cvar("surf_sp_time", "5")
	g_semi = register_cvar("surf_semi", "1")
	g_timer = register_cvar("surf_timer", "1")
	g_max = register_cvar("surf_timer_max", "86400")
	g_hud = register_cvar("Surf_timer_hud", "10.0")
	
	register_dictionary("surfmod.txt");
	
	register_clcmd("say /surfhelp","SurfHelpMOTD")
	register_clcmd("say_team /surfhelp","SurfHelpMOTD")
	register_clcmd("say /respawn", "RespawnComand")
	register_clcmd("say_team /respawn", "RespawnComand")
	register_clcmd("say /surftimer", "TimerMenu")
	register_clcmd("say_team /surftimer", "TimerMenu")

	register_event("DeathMsg", "DeathMsg","a")
	register_forward(FM_AddToFullPack, "AddToFullPack", 1)
	RegisterHam(Ham_Spawn, "player", "PlayerSpawn", 1)
	RegisterHam(Ham_Player_PreThink, "player", "PreThink", 1)
	
	SyncHud1 = CreateHudSyncObj();
	SayTxT = get_user_msgid("SayText");
	
	new MapName[64]
	get_mapname(MapName, 63)
	
	if(contain(MapName, "surf_") != -1 )
	{
		set_pcvar_num(g_on, 1)
	}
	else
	{
		set_pcvar_num(g_on, 0)
	}
}

public plugin_cfg()
{
	if(get_pcvar_num(g_on))
	{
		set_cvar_num("sv_airaccelerate", 100)

		new ConfDir[32], File[192];
		
		get_configsdir(ConfDir, charsmax(ConfDir));
		formatex(File, charsmax( File ), "%s/surfmod.cfg", ConfDir);
		
		if(!file_exists(File))
		{
			server_print("%L", LANG_SERVER, "CSF_ERROR", File);
		}
		else
		{
			server_cmd("exec %s", File);
			server_print("%L", LANG_SERVER, "CFG_EXEC", File);
		}
	}
}

public client_connect(id)
{
	remove_task(id+TASK_TIMER)
	remove_task(id+TASK_HUD)
}

public client_disconnect(id)
{
	remove_task(id+TASK_TIMER)
	remove_task(id+TASK_HUD)
	remove_task(id)
	ClearUserAlive(id)
}

public client_putinserver(id)
{
	CheckUser(id)
}

public CheckUser(id)
{
	if(!get_pcvar_num(g_on) || !get_pcvar_num(g_res) && is_user_alive(id) && !is_user_connected(id) || cs_get_user_team(id) == CS_TEAM_SPECTATOR || cs_get_user_team(id) == CS_TEAM_UNASSIGNED)
		return

	set_task(get_pcvar_float(g_restime), "Respawning", id)
	set_task(get_pcvar_float(g_helpint), "SurfCommands", id)
}

public DeathMsg(id)
{
	if(get_pcvar_num(g_on))
	{
		id = read_data(2)
		
		if(get_pcvar_num(g_res))
		{
			set_task(get_pcvar_float(g_restime),"Respawning", id)
		}
		
		if(get_pcvar_num(g_semi))
		{
			if(is_user_alive(id))
			{
				MarkUserAlive(id)
			}
			else
			{
				ClearUserAlive(id)
			}
		}
		
		if(get_pcvar_num(g_timer))
		{
			remove_task(id+TASK_TIMER)
			set_task(get_pcvar_float(g_hud), "StopHud", id)
		}
	}
}

public PlayerSpawn(id)
{
	if(get_pcvar_num(g_on))
	{
		if(get_pcvar_num(g_spenabled) && is_user_alive(id))
		{
			remove_task(id)
			set_user_godmode(id)
			set_user_rendering(id)
			Glowing(id)
			Protection(id)
		}
		
		if(get_pcvar_num(g_semi))
		{
			if(is_user_alive(id))
			{
				MarkUserAlive(id)

				const XTRA_OFS_PLAYER = 5
				const m_iTeam = 114
				g_iTeam[id] = get_pdata_int(id, m_iTeam, XTRA_OFS_PLAYER)
			}
			else
			{
				ClearUserAlive(id)
			}
		}
	}
}

public SurfHelpMOTD(id)
{
	if(get_pcvar_num(g_on) && get_pcvar_num(g_help) && is_user_connected(id))
	{
		show_motd(id, "surfmodhelp.txt", "Surf Mod Help");
	}
}

public SurfCommands(id)
{
	if(get_pcvar_num(g_on) && get_pcvar_num(g_help) && is_user_connected(id))
	{
		client_printcolor(id, "%L", LANG_SERVER, "HELP_MESS", prefix)
		set_task(get_pcvar_float(g_helpint),"SurfCommands")
	}
}

public RespawnComand(id)
{
	if(get_pcvar_num(g_on))
	{
		if(get_pcvar_num(g_res))
		{
			if(get_pcvar_num(g_res_com) && is_user_connected(id))
			{
				new CsTeams:team = cs_get_user_team(id)
			
				if(team == CS_TEAM_T || team == CS_TEAM_CT)
				{
					set_task(get_pcvar_float(g_restime),"Respawning",id)
				}
				else
				{
					client_printcolor(id, "%L", LANG_SERVER, "RES_TEAM", prefix)
					return
				}
			}
			else
			{
				client_printcolor(id, "%L", LANG_SERVER, "RES_COM", prefix)
				return
			}
		}
		else
		{
			client_printcolor(id, "%L", LANG_SERVER, "RES_DIS", prefix)
			return
		}
	}
}

public Respawning(id)
{
	if(cs_get_user_team(id) == CS_TEAM_SPECTATOR || cs_get_user_team(id) == CS_TEAM_UNASSIGNED || !is_user_connected(id))
		return
		
	ExecuteHamB(Ham_CS_RoundRespawn,id)
	
	remove_task(id+TASK_TIMER)
	remove_task(id+TASK_HUD)
	
	SurfTimer[id] = 0 
	
	if(is_user_alive(id))
	{
		client_printcolor(id, "%L", LANG_SERVER, "RESPAWN", prefix)
		give_item(id, "weapon_knife")
	}
} 

public Glowing(id)  
{  	
	new CsTeams:team = cs_get_user_team(id)
	
	if(team == CS_TEAM_T)
	{
		set_user_rendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 10)
	}
	else if(team == CS_TEAM_CT)
	{
		set_user_rendering(id, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 10)
	}
	SPTimer[id] = get_pcvar_num(g_sptime)
}  

public Protection(id)
{
	set_user_godmode(id,1)
	
	if(SPTimer[id] == 0)
	{
		set_hudmessage(255, 0, 0, -1.0, 0.65, 1, 0.02, 3.0,_,_,-1)
		show_hudmessage(id, "%L", LANG_SERVER, "PROT_OFF")
	}
	else
	{
		set_hudmessage(0, 255, 0, -1.0, 0.65, 0, 0.02, 0.8,_,_,-1)
		show_hudmessage(id, "%L", LANG_SERVER, "PROT_ON", SPTimer[id],SPTimer[id] > 1 ? "s" : "")
	}
	
	--SPTimer[id]
	
	if(SPTimer[id] >= 0)
	{
		set_task(1.0,"Protection",id)
	}
	else
	{
		set_user_godmode(id)
		set_user_rendering(id)
	}
}

public AddToFullPack(es, e, iEnt, id, hostflags, player, pSet)
{
	if(get_pcvar_num(g_on) && get_pcvar_num(g_semi) && player && id != iEnt && IsAlive(id) && g_iTeamSemiclip & g_iTeam[id] && IsAlive(iEnt) && g_iTeam[id] == g_iTeam[iEnt] && get_orig_retval())
	{ 
		set_es(es, ES_Solid, SOLID_NOT)
	}
} 

public PreThink(id)
{
	if(!get_pcvar_num(g_on) || !get_pcvar_num(g_semi) || IsAlive(id) == 0 || !(g_iTeamSemiclip & g_iTeam[id]))
	{ 
		return
	}
	
	new iPlayers[MAX_PLAYERS], iNum, iPlayer
	get_players(iPlayers, iNum, "ae", g_szTeams[g_iTeam[id]])
	
	for(new i; i<iNum; i++)
	{
		iPlayer = iPlayers[i]
		if(id != iPlayer)
		{
			entity_set_int(iPlayer, EV_INT_solid, SOLID_NOT)
		}
	}
}

public client_PostThink(id)
{
	if(!get_pcvar_num(g_on) || !get_pcvar_num(g_semi) || IsAlive(id) == 0 || !(g_iTeamSemiclip & g_iTeam[id]))
	{
		return
	}
	
	new iPlayers[MAX_PLAYERS], iNum, iPlayer
	get_players(iPlayers, iNum, "ae", g_szTeams[g_iTeam[id]])
	
	for(new i; i<iNum; i++)
	{
		iPlayer = iPlayers[i]
		if(id != iPlayer)
		{
			entity_set_int(iPlayer, EV_INT_solid, SOLID_SLIDEBOX)
		}
	}
}

public TimerMenu(id)
{
	if(is_user_alive(id) && get_pcvar_num(g_on) && get_pcvar_num(g_timer))
	{
		new timer_menu = menu_create("SurfMod Timer Menu", "ShowTimerMenu")
         
		menu_additem(timer_menu,"(RE)Star Timer","1",0)
		menu_additem(timer_menu,"Pause Timer","2",0)
		menu_additem(timer_menu,"UNPause Timer","3",0)
		menu_additem(timer_menu,"Stop Timer","4",0)
		menu_setprop(timer_menu, MPROP_EXIT, MEXIT_ALL)
		menu_display(id, timer_menu, 0)
	}
}

public ShowTimerMenu(id, timer_menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(timer_menu)
		return PLUGIN_HANDLED_MAIN
	}
     
	new data[6], iName[64], access, callback
     
	menu_item_getinfo(timer_menu, item, access, data,5, iName, 63, callback)
     
	new key = str_to_num(data)
     
	switch(key)
	{   
		case 1:
		{
			reStartTimer(id)
		}
		case 2:
		{
			PauseTimer(id)
		}
		case 3:
		{
			UNPauseTimer(id)
		}
		case 4:
		{
			StopTimer(id)
		}
	}
     	TimerMenu(id)
	menu_destroy(timer_menu) 
	return PLUGIN_HANDLED_MAIN
}

public reStartTimer(id)
{
	if(is_user_connected(id) && is_user_alive(id))
	{
		remove_task(id+TASK_TIMER)
		SurfTimer[id] = 0
		set_task(1.0,"TimerMain",id+TASK_TIMER)
		if(!task_exists(id+TASK_HUD))
		{
			TimerHud(id+TASK_HUD)
		}
	}
}

public TimerMain(id)
{
	id -= TASK_TIMER
	
	if(is_user_connected(id) && SurfTimer[id] < get_pcvar_num(g_max))
	{
		SurfTimer[id] += 1
         
		set_task(1.0, "TimerMain", id+TASK_TIMER)
	}
	else
	{
		remove_task(id+TASK_TIMER)
	}
}   

public TimerHud(id)
{
	id -= TASK_HUD
	
	if(is_user_connected(id))
	{
		set_hudmessage(0, 255, 0, -1.0, 0.85, 0, 0.0, 0.3, 0.0, 0.0, -1)
		ShowSyncHudMsg(id, SyncHud1, "%L", LANG_SERVER, "TIMER", SurfTimer[id], SurfTimer[id] > 1 ? "s" : "")
		
		set_task(0.1,"TimerHud",id+TASK_HUD)
	}
}

public PauseTimer(id)
{
	if(is_user_connected(id) && is_user_alive(id))
	{
		if(task_exists(id+TASK_TIMER))
		{
			remove_task(id+TASK_TIMER)
		}
	}
}

public UNPauseTimer(id)
{
	if(is_user_connected(id) && is_user_alive(id))
	{
		if(!task_exists(id+TASK_TIMER))
		{
			set_task(0.1,"TimerMain",id+TASK_TIMER)
		}
	}
}

public StopTimer(id)
{
	if(is_user_connected(id) && is_user_alive(id))
	{
		if(task_exists(id+TASK_TIMER))
		{
			remove_task(id+TASK_TIMER)
			set_task(get_pcvar_float(g_hud), "StopHud", id)
		}
	}
}

public StopHud(id)
{
	if(is_user_connected(id))
	{
		remove_task(id+TASK_HUD)
	}
}

stock client_printcolor(const id, const input[], any:...)
{
	new count = 1, players[32];
	static msg[191];
	vformat(msg,190,input,3);
	replace_all(msg,190,"!g","^4");
	replace_all(msg,190,"!n","^1");
	replace_all(msg,190,"!t","^3");
	replace_all(msg,190,"!w","^0");
	if(id) players[0] = id; else get_players(players,count,"ch");
	for (new i = 0; i < count; i++)
		if(is_user_connected(players[i]))
		{
			message_begin(MSG_ONE_UNRELIABLE, SayTxT,_, players[i]);
			write_byte(players[i]);
			write_string(msg);
			message_end();
		}
}
